package magazzino;

import java.util.List;

import magazzino.utils.IFormatter;

/**
 * È fondamentalmente una struttura dati che riceve i dati di stock dal
 * {@link Formatter}. La logica del ciclo giornaliero è tale per cui il file
 * Vettura rappresenta la vettura con ultimo campo i giorni e il caricamento
 * avviene la mattino nel magazzino centrale stesso su file (giorno 0). Se ci
 * sono stock non scaricati del tutto il campo giorno viene +1, perché si usa lo
 * stesso file Vettura. Es: vattura1.txt è caricato con 50 Nike(42) 0, viene
 * istanziata una vettura(vettura1) da cui si scaricano 20 paia, a fine giornata
 * si avranno 30 Nike(42) 1, e si riusa lo steso file magari caricando altre
 * scarpe e se le Nike(42) non sono state ancora scaricate il giorno fa +1
 * finché il controllo in DataWriter non fa aggiornate il report di
 * oldstock.txt.
 * 
 * @author koelio
 * @see Formatter, Vettura, DataWriter
 * 
 */
public class Vettura {

	private IFormatter formatted;
	private String vettura;
	private int quantity[];
	private List<String> models;
	private int measures[];
	private int days[];

	public Vettura(IFormatter formatted) {
		this.formatted = formatted;

		this.vettura = formatted.getVettura();
		this.quantity = formatted.getQuantities();
		models = formatted.getModels();
		this.measures = formatted.getMeasures();
		this.days = formatted.getDays();
	}

	public IFormatter getFormatted() {
		return formatted;
	}

	public String getVettura() {
		return vettura;
	}

	public void setVettura(String vettura) {
		this.vettura = vettura;
	}

	public int[] getQuantity() {
		return quantity;
	}

	public void setQuantity(int index, int quantity) {
		this.quantity[index] = quantity;
	}

	public List<String> getModels() {
		return models;
	}

	public void setModel(int index, String model) {
		this.models.set(index, model);
	}

	public int[] getMeasure() {
		return measures;
	}

	public void setMeasure(int index, int measure) {
		this.measures[index] = measure;
	}

	public int[] getDay() {
		return days;
	}

	public void setDay(int index, int day) {
		this.days[index] = day;
	}

}